function [stdresid,UnifMargins, Qt, Rt]=SimulateDccResiduals(k,t,dccparameters)
% PURPOSE:
%     Simulate correlated residuals that follow a dynamic correlation
%     specification same as the DCC(1,1)
% 
% INPUTS:
%     k                - the number of series to be returned
%     t                - The length of the data to be returned
%     CorrMat          - A k by k matrix of unconditional correlation
%     garchparameters  - A vector of garch parameters for the univatiate garch processes, 
%                          k+sum(archP)+sum(garchQ) by 1 of the form [omega(1) a(11) (a12) ... a(1archP(1)) b(11) ... b(1(garchQ(1))
%                          omega(2) ... b(2garchQ(2)) ... omega(k) ... b(kgarchQ(k))
%     archP            - A vector of lag lengths of the individual garch innovations [k by 1]
%     garchQ           - A vector of lag lengths of the individual garch AR terms [k by 1]
%     dccparameters    - The DCC parameters (DccP+DccQ x 1)
%     dccP             - The order of the DCC innovation term
%     dccQ             - The order of the DCC AR term
%     state            - (optional) The state to which to set randn.  Should be a 2 vector.  
%                      If not included, the state is reinitialized by randn('state',sum(100*clock));
% 
% OUTPUTS:
%  stdresid  - The simulated residuals from the entered parameters, t x k
%  Qt        - The estimated variance-covariance k x k x t
%  Rt        - The estimated correlation k x k x 
% -------------------------------------------------------------------------
% This function is based on Kevin Sheppard's code in UCSD-GARCH toolbox 
% -------------------------------------------------------------------------
      
m=1;
rawdata=randn(t+m,k);

Qbar=gallery('randcorr',k);
[samplstd samplecorr]=cov2corr(Qbar);
stdresid=randn(t,k);

dccA=dccparameters(1);
dccB=dccparameters(2);
Qt=zeros(k,k,t);
Qt(:,:,1:m)=repmat(Qbar,[1 1 m]);
Rt=zeros(k,k,t);
Rt(:,:,1)=samplecorr;
Qt(:,:,1:m)=repmat(Qbar,[1 1 m]);
P=1; Q=1;
for j=(m+1):t
    Qt(:,:,j)=Qbar*(1-dccA-dccB);   
    for i=1:P
        Qt(:,:,j)=Qt(:,:,j)+dccA(i)*(stdresid(j-i,:)'*stdresid(j-i,:));
    end
    for i=1:Q
        Qt(:,:,j)=Qt(:,:,j)+dccB(i)*Qt(:,:,j-i);
    end
    Rt(:,:,j)=Qt(:,:,j)./(sqrt(diag(Qt(:,:,j)))*sqrt(diag(Qt(:,:,j)))');
    stdresid(j,:)=rawdata(j,:)*(Rt(:,:,j))^(0.5);

end;
UnifMargins=normcdf(stdresid); %This is the normal copula!!!